--- Schema für Demodaten-Funktionen
CREATE SCHEMA IF NOT EXISTS z_99_demo;
-- ALTER ROLE  "SYS.Personaldaten" WITH CREATEROLE; -- wieso? wird doch >>SELECT TSystem.create__role_group( 'SYS.Personaldaten', 'GROUP', $$ CREATEROLE $$ );     -- Personaldaten sind zu sehen<< erstellt?!
-- ALTER GROUP "SYS.Personaldaten" ADD USER "DEMODATA";

SELECT TSystem.grant__table_funktion_sequence_schema_privileg__to__rolle('SYS.Prodat-User');

-- Owner für DemoDaten
SET SESSION AUTHORIZATION 'DEMODATA';

SELECT setval('loginrole_lro_id_seq', max_lro_id)
FROM (
    SELECT max(lro_id) AS max_lro_id FROM loginrole
) AS sub;

DO $$
BEGIN
    -- Lizenzen
    INSERT INTO lizenzedmodules (lzm_modclassname) VALUES ('TFormMyMaschines'), ('TFormDokverwaltung'), ('TFormMitarbSkills'), ('TFormOLAPBI');

    -- Steuercodes für Deutschland anlegen
    PERFORM TSystem.Settings__Set('einksteucode', 9);
    PERFORM TSystem.Settings__Set('auftgsteucode', 3);

    PERFORM TSystem.Settings__Set('BASIS_W', 'EUR');

    PERFORM TSystem.Settings__Set('DMSInitialPath_art_SCD', '15');

    -- UserButtons anlegen -> über Trigger llv__a_iud__ll_db_login__userbuttons im nachfolgenden INSERT INTO llv
    --INSERT INTO userbuttons (usrbt_mm_id) VALUES
    --    (27)/*Adress*/,
    --    ...;

    PERFORM TSystem.Settings__Set('AG_POS_WIDTH', 10);
    PERFORM TSystem.Settings__Set('LD_POS_WIDTH', 10);
END $$ language plpgsql;

--
  -- Mitarbeiterstamm anlegen (Mitarbeiter TEST und CIMPCS)
  INSERT INTO adk
      (ad_krz, ad_name, ad_vorn, ad_ort, ad_landiso, ad_land, ad_vpber, ad_tel1, ad_email1)
    VALUES
      -- Nutzerliste siehe LLV "PSQL\9700 Demodaten\DemoDaten.0000.DemoUser.sql"
      ('DEMO',       'Mustermann',   'Max',                'Musterhausen', 'DE', 'Deutschland', 1, NULL, NULL),
      ('DEMODATA',   'Mustermann',   'Max',                'Musterhausen', 'DE', 'Deutschland', 1, NULL, NULL),
      ('PRAKTIKANT', 'Kant',         'Prakti',             'Musterhausen', 'DE', 'Deutschland', 1, NULL, NULL),
      ('TC',         'TestComplete', 'T.C.',               'Musterhausen', 'DE', 'Deutschland', 1, NULL, NULL),
      -- Benutzer für Strukturanpassungen Datenbank aus TestComplete heraus
      ('TC-ADMIN',   'TC-ADMIN',     'TestComplete-Admin', 'Musterhausen', 'DE', 'Deutschland', 1, NULL, NULL),
      --
      ('ACJ',  'Achtmann', 'Jens',        'Dresden', 'DE', 'Deutschland', 1, '+49 351 30 98 60 90', 'j.achtmann@prodat-erp.de'),
      ('AFL',  'Flüss', 'Andreas',        'Dresden', 'DE', 'Deutschland', 1, NULL, NULL),
      ('AKU',  'Kutepow', 'Andre',        'Dresden', 'DE', 'Deutschland', 1, '+49 351 30 98 60 90', 'a.kutepow@prodat-erp.de'),
      ('AXS',  'Schneider', 'Axel',       'Dresden', 'DE', 'Deutschland', 1, '+49 351 30 98 60 90', 'a.schneider@prodat-erp.de'),
      ('FS',   'Semmling', 'Frank',       'Dresden', 'DE', 'Deutschland', 1, '+49 351 30 98 60 90', 'f.semmling@prodat-erp.de'),
      ('GEO',  'Gettinger', 'Oleg',       'Dresden', 'DE', 'Deutschland', 1, '+49 351 30 98 60 90', 'd.schuchardt@prodat-erp.de'),
      ('MF',   'Friedmann', 'Marcus',     'Dresden', 'DE', 'Deutschland', 1, '+49 351 30 98 60 90', 'm.friedmann@prodat-erp.de'),
      ('MIJ',  'Michel', 'Jens',          'Dresden', 'DE', 'Deutschland', 1, '+49 351 30 98 60 90', 'j.michel@prodat-erp.de'),
      ('WOP',  'Wolak', 'Philipp',        'Dresden', 'DE', 'Deutschland', 1, '+49 351 30 98 60 90', 'p.wolak@prodat-erp.de'),
      ('RK',   'Kreutz', 'Rocco',         'Dresden', 'DE', 'Deutschland', 1, '+49 351 30 98 60 90', 'r.kreuz@prodat-erp.de'),
      ('SCD',  'Schuchardt', 'Daniel',    'Dresden', 'DE', 'Deutschland', 1, '+49 351 30 98 60 90', 'd.schuchardt@prodat-erp.de'),
      ('STA',  'Angrick', 'Steffen',      'Dresden', 'DE', 'Deutschland', 1, '+49 351 30 98 60 90', 's.angrick@prodat-erp.de');


  INSERT INTO personal
      (pers_krz)
    VALUES
      -- Nutzerliste siehe oben ADK, bzw. siehe LLV "PSQL\9700 Demodaten\DemoDaten.0000.DemoUser.sql"
      ('DEMO'),
    --('DEMODATA'),  = Login nur zum Anlegen der Testdaten
      ('PRAKTIKANT'),
      ('TC'),
      ('TC-ADMIN'),
      --
      ('ACJ'),
      ('AFL'),
      ('AKU'),
      ('AXS'),
      ('FS'),
      ('GEO'),
      ('MF'),
      ('MIJ'),
      ('WOP'),
      ('RK'),
      ('SCD'),
      ('STA');


  INSERT INTO llv
      (ll_minr, ll_ad_krz, ll_db_usename, ll_db_login, ll_passwd, ll_rfid)
    VALUES
      -- Nutzerliste siehe oben ADK, bzw. siehe LLV "PSQL\9700 Demodaten\DemoDaten.0000.DemoUser.sql"
      -- SELECT encode(convert_to(:password, 'UTF-8'), 'BASE64')
      -- Nutzer ohne Passwort bekommen lower(ll_db_usename) als Passwort  #16376
      (599,   'DEMO',       'DEMO',       true,  convert_from(decode('YmVpc3BpZWw=', 'BASE64'), 'UTF-8'),  NULL),  -- Testbenutzer, Password siehe https://redmine.prodat-sql.de/projects/prodat-v-x/keys
      (598,   'DEMODATA',   'DEMODATA',   true,  NULL,  NULL),
      (550,   'PRAKTIKANT', 'PRAKTIKANT', true,  NULL,  NULL),  -- CIMPCS-DB: 9999 PRAKTIKANT CIMPCS
      (597,   'TC',         'TC',         true,  convert_from(decode('dGVzdA==', 'BASE64'), 'UTF-8'),  NULL),  -- PW=test
      (596,   'TC-ADMIN',   'TC-ADMIN',   true,  NULL,  NULL),
      --
      (515,   'ACJ',        'ACJ',        true,  NULL,  NULL),
      (102,   'AFL',        'AFL',        true,  NULL,  NULL),  -- CIMPCS-DB: 102 AP-ALE AP-ALE
      (505,   'AKU',        'AKU',        true,  NULL,  NULL),
      (517,   'AXS',        'AXS',        true,  NULL,  NULL),
      (502,   'FS',         'FS',         true,  NULL,  NULL),
      (507,   'GEO',        'GEO',        true,  NULL,  NULL),
      (501,   'MF',         'MF',         true,  NULL,  NULL),
      (509,   'MIJ',        'MIJ',        true,  NULL,  NULL),
      (518,   'WOP',        'WOP',        true,  NULL,  NULL),
      (516,   'RK',         'RK',         true,  NULL,  NULL),  -- CIMPCS-DB: 516 KRR 516
      (987,   'SCD',        '987',        true,  NULL,  NULL),  -- CIMPCS-DB: 987 DS 987
      (508,   'STA',        'STA',        true,  NULL,  NULL);


-- Unternehmen CIMPCS anlegen
    INSERT INTO adk
      (ad_krz, ad_fa1, ad_str, ad_plz, ad_ort, ad_landiso, ad_land, ad_vpber, ad_tel1, ad_email1)
    VALUES
      -- Nutzerliste siehe llv
      ('CIMPCS', 'CIMPCS GmbH', 'Hoyerswerdaer Str 22', '01099', 'Dresden', 'DE', 'Deutschland', 1, '+49 351 30 98 60 90', 'd.schuchardt@prodat-erp.de');

    INSERT INTO llv
      (ll_minr, ll_ad_krz, ll_db_usename)
    VALUES
      -- DB-Logins siehe DemoDaten.0000.DemoUser.sql
      (999,   'CIMPCS',     'CIMPCS');  -- CIMPCS-DB: 999 PRAKTIKANT 999

--- Adresse #
    INSERT INTO adk
         (ad_krz, ad_fa1                     , ad_str              , ad_plz , ad_ort   , ad_landiso, ad_ustidnr        , ad_steunr)
    SELECT
          '#'   , 'PRODAT Unternehmensgruppe', 'Parallelstraße 987', '01099', 'Dresden', 'DE'      , 'UST-ID-123456789', 'SNR-123456789A'
    WHERE NOT EXISTS (SELECT TRUE FROM adk WHERE ad_krz = '#') ;



-- END DEMO-SESSION
RESET SESSION AUTHORIZATION;


-- User Rights DEMODATA OHNE SUPERUSER
UPDATE llv SET ll_db_login = true WHERE insert_by = 'DEMODATA' AND NOT ll_db_login;